<?php

namespace App\Http\Controllers;

use App\Models\Appendix;
use App\Http\Requests\StoreAppendixRequest;
use App\Http\Requests\UpdateAppendixRequest;
use App\Models\ClassRoom;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Response as FacadesResponse;
use Illuminate\Support\Facades\Storage;

class AppendixController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($roomId)
    {
        $room = ClassRoom::find($roomId);
        $appendixes = Appendix::where('room_id', $room->id)->get();
        return view('appendix.list')->with([
            'room' => $room,
            'appendixes' => $appendixes,
        ]);
    }

    public function listRoom($roomId)
    {
        $appendixes = Appendix::where('room_id',$roomId)->where('is_active',1)->get();
        return view('student.appendix')->with(['appendixes'=>$appendixes]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreAppendixRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAppendixRequest $request)
    {
        try {
            if ($request->fileUrl == null) {
                return back()->with(['error' => 'يرجى إرفاق المحق']);
            }
            // return $request;

            $newAppendix = new Appendix();
            $newAppendix->description = $request->description;
            $newAppendix->room_id = $request->roomId;
            $newAppendix->url = $request->fileUrl;
            $newAppendix->save();
            return back()->with(['success' => 'تم إضافة بيانات الملحق بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم إضافة بيانات الملحق  ']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Appendix  $appendix
     * @return \Illuminate\Http\Response
     */
    public function show(Appendix $appendix)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Appendix  $appendix
     * @return \Illuminate\Http\Response
     */
    public function edit(Appendix $appendix)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateAppendixRequest  $request
     * @param  \App\Models\Appendix  $appendix
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateAppendixRequest $request)
    {
        try {
            $appendix = Appendix::find($request->id);
            if (!$request->fileUrl == null) {
                if (Storage::disk('public')->exists('appendixes/' . $appendix->url)) {
                    Storage::disk('public')->delete('appendixes/' . $appendix->url);
                    $appendix->url = $request->fileUrl;
                }
            }
            $appendix->description = $request->description;
            $appendix->save();
            return back()->with(['success' => 'تم تعديل بيانات الملحق بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم تعديل بيانات الملحق  ']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Appendix  $appendix
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        try {
            $appendix = Appendix::find($request->id);
            if (Storage::disk('public')->exists('appendixes/' . $appendix->url)) {
                Storage::disk('public')->delete('appendixes/' . $appendix->url);
                if ($appendix->delete())
                    return back()->with(['success' => 'تم حذف الملحق بنجاح']);
            }
            return 'error';
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم حذفالدورة التدريبية ']);
        }
    }

    public function toggle(Request $request)
    {
        try {
            $appendix = Appendix::find($request->id);
            $appendix->is_active *= -1;
            $appendix->save();
            return back()->with(['success' => 'تمت تحديث البيانات بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات']);
        }
    }

    public function download($appendixId)
    {
        try {
            $appendix = Appendix::find($appendixId);
            $file = storage_path("app/public/appendixes/") . $appendix->url;
            $type = File::extension($file);
            $header = array(
                'Content-Type: application/' . $type
            );
            return FacadesResponse::download($file, "lesson_exercise.$type", $header);
        } catch (\Throwable $the) {
            return back()->with(['error' => 'عذرا لم نستطيع  تحميل قد يكون الملف محذوف ']);
        }
    }
}
